classdef TriangleCovTreeNode < handle
    % Node in TriangleCovTree 
    %  
    % Copyright (C) Russell H. Taylor 2013
    % For use with CIS I only
    % Do not redistribute without written permission from Russell Taylor

     
    properties
        Tree        % Pointer at tree
        F           % covFrame
        Fi          % inverse Frame
        BB          % Bounding Box
        minTx       % Minimum index
        maxTx       % Max index
        splitTx     % Minimum index of right subtree (0 if unsplit)
        Left        % Left subtree
        Right       % Right subtree
    end
    
    methods
        function TN = TriangleCovTreeNode(Tree,minTx,maxTx)
            display({'Node',minTx,maxTx,maxTx-minTx+1});
            TN.Tree = Tree;
            TN.minTx = minTx;
            TN.maxTx = maxTx;
            Vs = vct3Array(maxTx-minTx+1);
            V  = vct3Array((maxTx-minTx+1)*3);
            for j=minTx:maxTx
                i=j-minTx;
                [TV]=Tree.Mesh.Triangle(Tree.Tx(j));
                V.el(:,(3*i+1):(3*i+3)) = TV.el;
                Vs(i+1) = TV.mean();
            end
            TN.F = covFrame(Vs);
            TN.Fi = TN.F.Inverse();
            TN.BB = vct3BoundingBox();
            TN.BB.Add(TN.Fi*V);
            display(TN.F);
            if (maxTx-minTx)<Tree.minN
                TN.Left = 0; TN.Right = 0; TN.splitTx = 0;
                return;
            end
            % now do split sort
            FiVs = TN.Fi*Vs;
            % display(FiVs);
            j = minTx;k=maxTx+1;
            while j<k
                FiVj1 = FiVs.el(1,j-minTx+1);
                if FiVj1>0
                    % Vs(j).X() > 0, find something to swap with
                    k = k-1;
                    while k>j
                        FiVk1 = FiVs.el(1,k-minTx+1);
                        if FiVk1<0
                            % found one to swap
                            % display({'swapping',j,k,FiVj1,FiVk1});
                            tmp = Tree.Tx(j);
                            Tree.Tx(j)=Tree.Tx(k);
                            Tree.Tx(k)=tmp;
                            break;
                        else
                            k=k-1;
                        end
                    end
                end
                j=j+1;
            end
            if minTx<k && k<=maxTx
                TN.splitTx = k;
                TN.Left = TriangleCovTreeNode(Tree,minTx,k-1);
                TN.Right = TriangleCovTreeNode(Tree,k,maxTx);
            else
                {'Unexpected failure to find splitting point',minTx,k,maxTx}
                TN.splitTx=0;
            end
        end
        
        function [cp,ct,cd] = LinearSearchForClosestPoint(TN,pt,prev_cp,prev_ct,prev_cd)
            cp = prev_cp; ct=prev_ct; cd=prev_cd;
            v = TN.Fi*pt;
            if TN.BB.Includes(v,cd)
                % may have something within the box
                for i = TN.minTx:TN.maxTx
                    t = TN.Tree.Tx(i);
                    [TV,p,q,r] = Triangle(TN.Tree.Mesh,t);
                    [p,d] = TriangleClosestPoint(pt,p,q,r);
                    if d<cd
                        cp = p; ct = t; cd=d;
                    end                        
                end
            else
                skipped = 1;
            end
        end
        
        function [cp,ct,cd] = SearchForClosestPoint(TN,pt,prev_cp,prev_ct,prev_cd)
            cp = prev_cp; ct=prev_ct; cd=prev_cd;
            v = TN.Fi*pt;
            if TN.BB.Includes(v,cd)
                if TN.splitTx
                    [cp,ct,cd] = SearchForClosestPoint(TN.Left,pt,cp,ct,cd);
                    [cp,ct,cd] = SearchForClosestPoint(TN.Right,pt,cp,ct,cd);
                else
                    [cp,ct,cd] = LinearSearchForClosestPoint(TN,pt,cp,ct,cd);
                end
            end
        end
    end
    
end

